/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4 BIT PARALLEL ACCESS SHIFT REGISTERS 
TRUTHTABLE     : 

     ------------------------------------------------------------
     MODE   CLK2  CLK1     SERIN      A--B--C--D    QA--QB--QC--QD  
     ------------------------------------------------------------
      H      H     X        X       X  X  X  X    QA  QB  QC  QD 
      H      F     X        X       A  B  C  D    A   B   C   D
      H      F     X        X       QB QC QD D    QB  QC  QD  D   # SEE NOTE
                            
      L      L     H        X       X  X  X  X    QA  QB  QC  QD 
      L      X     F        H       X  X  X  X    H   QA  QB  QC 
      L      X     F        L       X  X  X  X    L   QA  QB  QC 

      R      L     L        X       X  X  X  X    QA  QB  QC  QD 
      F      L     L        X       X  X  X  X    QA  QB  QC  QD 
      F      L     H        X       X  X  X  X    QA  QB  QC  QD 
      R      H     L        X       X  X  X  X    QA  QB  QC  QD 
      R      H     H        X       X  X  X  X    QA  QB  QC  QD 

    NOTE 1. QB, QC, QD  REQUIRES EXTERNAL CONNECTIONS TO A, B, C RESPECTIVELY.
           2. 'R' AND 'F' INDICATE RISING EDGE AND FALLING EDGE RESPECTIVELY.
     ------------------------------------------------------------

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a95 (serin, a, b, c, d, mode, clk2, clk1, qd, qc, qb, qa);
	parameter size =1;
	input
		serin,
		a,
		b,
		c,
		d,
		mode,
		clk2,
		clk1;
	output
		qd,
		qc,
		qb,
		qa;
    reg
        NOTIFY_REG;
    not
	  (m95_inst_mode_, mode);
    and
	  (m95_inst_rt_mode, clk1, m95_inst_mode_);
    and
	  (m95_inst_lt_mode, clk2, mode);
    nor  
	  (m95_inst_dir_cntrl_clk, m95_inst_rt_mode, m95_inst_lt_mode);
    and
	  (m95_inst_l_1, serin, m95_inst_mode_);
    and
	  (m95_inst_r_1, a, mode);
    and
	  (m95_inst_l_2, m95_inst_qaint, m95_inst_mode_);
    and
	  (m95_inst_r_2, b, mode);
    and
	  (m95_inst_l_3, m95_inst_qbint, m95_inst_mode_);
    and
	  (m95_inst_r_3, c, mode);
    and
	  (m95_inst_l_4, m95_inst_qcint, m95_inst_mode_);
    and
	  (m95_inst_r_4, d, mode);
    nor
	  (m95_inst_rc_data1, m95_inst_l_1, m95_inst_r_1);
    nor
	  (m95_inst_rc_data2, m95_inst_l_2, m95_inst_r_2);
    nor
	  (m95_inst_rc_data3, m95_inst_l_3, m95_inst_r_3);
    nor
	  (m95_inst_rc_data4, m95_inst_l_4, m95_inst_r_4);
    not
	  (m95_inst_rs_data1_, m95_inst_rc_data1);
    not
	  (m95_inst_rs_data2_, m95_inst_rc_data2);
    not
	  (m95_inst_rs_data3_, m95_inst_rc_data3);
    not
	  (m95_inst_rs_data4_, m95_inst_rc_data4);
    buf
	  (qa, m95_inst_qaint);
    buf
	  (qb, m95_inst_qbint);
    buf
	  (qc, m95_inst_qcint);
    buf
	  (qd, m95_inst_qdint);
    U_FD_P_NO  
	M95_inst_RSND1_inst1 (m95_inst_qaint, m95_inst_rs_data1_, m95_inst_dir_cntrl_clk, NOTIFY_REG);
    U_FD_P_NO  
	M95_inst_RSND2_inst1 (m95_inst_qbint, m95_inst_rs_data2_, m95_inst_dir_cntrl_clk, NOTIFY_REG);
    U_FD_P_NO  
	M95_inst_RSND3_inst1 (m95_inst_qcint, m95_inst_rs_data3_, m95_inst_dir_cntrl_clk, NOTIFY_REG);
    U_FD_P_NO  
	M95_inst_RSND4_inst1 (m95_inst_qdint, m95_inst_rs_data4_, m95_inst_dir_cntrl_clk, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
